<?php
session_start();
require_once 'config/db.php';

if (!isset($_GET['token'])) die("Token inválido");
$token = $_GET['token'];

$stmt = $pdo->prepare("SELECT * FROM tokens_recuperacion WHERE token = ? AND expira > NOW()");
$stmt->execute([$token]);
$info = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$info) die("Enlace vencido o inválido");

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $pass = password_hash($_POST['nueva'], PASSWORD_DEFAULT);
    $pdo->prepare("UPDATE usuarios SET password = ? WHERE id = ?")->execute([$pass, $info['usuario_id']]);
    $pdo->prepare("DELETE FROM tokens_recuperacion WHERE token = ?")->execute([$token]);
    header("Location: login.php");
    exit;
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Restablecer contraseña - Impreza ERP</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-5">
    <h3 class="mb-4">Restablecer contraseña</h3>
    <form method="POST">
        <input name="nueva" type="password" class="form-control mb-3" placeholder="Nueva contraseña" required>
        <button class="btn btn-success">Cambiar contraseña</button>
    </form>
</div>
</body>
</html>
