<?php
session_start();
require_once 'config/db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = $_POST['email'];
    $stmt = $pdo->prepare("SELECT id FROM usuarios WHERE email = ?");
    $stmt->execute([$email]);
    $usuario = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($usuario) {
        $token = bin2hex(random_bytes(16));
        $expira = date("Y-m-d H:i:s", strtotime("+1 hour"));
        $pdo->prepare("INSERT INTO tokens_recuperacion (usuario_id, token, expira) VALUES (?, ?, ?)")
            ->execute([$usuario['id'], $token, $expira]);

        $link = "https://" . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']) . "/reset.php?token=$token";
        $mensaje = "Haz clic para restablecer tu contraseña: $link";
        mail($email, "Recuperar contraseña - Impreza ERP", $mensaje);

        $msg = "Se ha enviado un correo con instrucciones.";
    } else {
        $msg = "Correo no encontrado.";
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Recuperar contraseña - Impreza ERP</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-5">
    <h3 class="mb-4">Recuperar contraseña</h3>
    <?php if (isset($msg)): ?><div class="alert alert-info"><?= $msg ?></div><?php endif; ?>
    <form method="POST">
        <input name="email" type="email" class="form-control mb-3" placeholder="Tu correo registrado" required>
        <button class="btn btn-primary">Enviar enlace</button>
    </form>
</div>
</body>
</html>
