<?php
session_start();
require_once '../config/db.php';
if (!isset($_SESSION['usuario_id'])) {
    header('Location: ../login.php');
    exit;
}

$ventas = $pdo->query("
    SELECT v.id, c.nombre AS cliente, u.nombre AS vendedor, v.fecha, v.total, v.estado
    FROM ventas v
    JOIN clientes c ON v.cliente_id = c.id
    JOIN vendedores vd ON v.vendedor_id = vd.id
    JOIN usuarios u ON vd.usuario_id = u.id
    ORDER BY v.fecha DESC
")->fetchAll(PDO::FETCH_ASSOC);

function getProductosVenta($pdo, $venta_id) {
    $stmt = $pdo->prepare("
        SELECT p.nombre, dv.cantidad
        FROM detalle_ventas dv
        JOIN productos p ON dv.producto_id = p.id
        WHERE dv.venta_id = ?
    ");
    $stmt->execute([$venta_id]);
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Ventas - Impreza ERP</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
    <div class="container py-5">
        <h1 class="mb-4">Ventas Registradas</h1>
        <table class="table table-bordered table-striped align-middle">
            <thead class="table-dark">
                <tr>
                    <th>ID</th>
                    <th>Cliente</th>
                    <th>Vendedor</th>
                    <th>Fecha</th>
                    <th>Total</th>
                    <th>Estado</th>
                    <th>Productos</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($ventas as $v): ?>
                    <tr>
                        <td><?= $v['id'] ?></td>
                        <td><?= htmlspecialchars($v['cliente']) ?></td>
                        <td><?= htmlspecialchars($v['vendedor']) ?></td>
                        <td><?= $v['fecha'] ?></td>
                        <td>$<?= number_format($v['total'], 0, ',', '.') ?></td>
                        <td><span class="badge bg-<?= $v['estado'] === 'pagada' ? 'success' : ($v['estado'] === 'anulada' ? 'danger' : 'warning') ?>">
                            <?= $v['estado'] ?>
                        </span></td>
                        <td>
                            <ul class="mb-0">
                                <?php foreach (getProductosVenta($pdo, $v['id']) as $p): ?>
                                    <li><?= htmlspecialchars($p['nombre']) ?> <span class="text-muted">(x<?= $p['cantidad'] ?>)</span></li>
                                <?php endforeach; ?>
                            </ul>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</body>
</html>
