<?php
session_start();
require_once '../config/db.php';
if (!isset($_SESSION['usuario_id'])) {
    header('Location: ../login.php');
    exit;
}

// Obtener clientes y vendedores
$clientes = $pdo->query("SELECT id, nombre FROM clientes")->fetchAll(PDO::FETCH_ASSOC);
$vendedores = $pdo->query("SELECT v.id, u.nombre FROM vendedores v JOIN usuarios u ON v.usuario_id = u.id")->fetchAll(PDO::FETCH_ASSOC);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $cliente_id = $_POST['cliente_id'];
    $vendedor_id = $_POST['vendedor_id'];
    $fecha = $_POST['fecha'];
    $total = $_POST['total'];
    $stmt = $pdo->prepare("INSERT INTO ventas (cliente_id, vendedor_id, fecha, total) VALUES (?, ?, ?, ?)");
    $stmt->execute([$cliente_id, $vendedor_id, $fecha, $total]);
    $mensaje = "Venta registrada exitosamente.";
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Registrar Venta - Impreza ERP</title>
</head>
<body>
    <h1>Registrar Venta</h1>
    <?php if (!empty($mensaje)) echo "<p style='color:green;'>$mensaje</p>"; ?>
    <form method="POST">
        <label for="cliente_id">Cliente:</label>
        <select name="cliente_id" required>
            <?php foreach ($clientes as $c): ?>
                <option value="<?= $c['id'] ?>"><?= htmlspecialchars($c['nombre']) ?></option>
            <?php endforeach; ?>
        </select><br>

        <label for="vendedor_id">Vendedor:</label>
        <select name="vendedor_id" required>
            <?php foreach ($vendedores as $v): ?>
                <option value="<?= $v['id'] ?>"><?= htmlspecialchars($v['nombre']) ?></option>
            <?php endforeach; ?>
        </select><br>

        <label for="fecha">Fecha:</label>
        <input type="date" name="fecha" required><br>

        <label for="total">Total de la venta:</label>
        <input type="number" step="0.01" name="total" required><br>

        <button type="submit">Registrar Venta</button>
    </form>
</body>
</html>
