<?php
session_start();
require_once '../config/db.php';

$ventas = $pdo->query("
    SELECT v.id, v.fecha, c.nombre AS cliente
    FROM ventas v
    JOIN clientes c ON v.cliente_id = c.id
    ORDER BY v.fecha DESC
")->fetchAll(PDO::FETCH_ASSOC);

function calcularUtilidad($pdo, $venta_id) {
    $stmt = $pdo->prepare("
        SELECT p.precio_compra, pv.precio, pv.cantidad
        FROM productos_vendidos pv
        JOIN productos p ON pv.producto_id = p.id
        WHERE pv.venta_id = ?
    ");
    $stmt->execute([$venta_id]);
    $total_utilidad = 0;
    foreach ($stmt->fetchAll(PDO::FETCH_ASSOC) as $item) {
        $margen = ($item['precio'] - $item['precio_compra']) * $item['cantidad'];
        $total_utilidad += $margen;
    }
    return $total_utilidad;
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Utilidades - Impreza ERP</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-5">
    <h2 class="mb-4">Utilidad por Venta</h2>
    <table class="table table-bordered">
        <thead class="table-dark">
            <tr><th>ID Venta</th><th>Fecha</th><th>Cliente</th><th>Utilidad</th></tr>
        </thead>
        <tbody>
            <?php foreach ($ventas as $v): ?>
                <tr>
                    <td><?= $v['id'] ?></td>
                    <td><?= $v['fecha'] ?></td>
                    <td><?= htmlspecialchars($v['cliente']) ?></td>
                    <td class="text-success">$<?= number_format(calcularUtilidad($pdo, $v['id']), 0, ',', '.') ?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>
</body>
</html>
