<?php
require '../vendor/autoload.php';
require_once '../config/db.php';

use Dompdf\Dompdf;

$filtro = '';
$params = [];

if (!empty($_GET['cliente'])) {
    $filtro .= " AND c.nombre LIKE ?";
    $params[] = "%" . $_GET['cliente'] . "%";
}

if (!empty($_GET['vendedor'])) {
    $filtro .= " AND u.nombre LIKE ?";
    $params[] = "%" . $_GET['vendedor'] . "%";
}

if (!empty($_GET['desde']) && !empty($_GET['hasta'])) {
    $filtro .= " AND v.fecha BETWEEN ? AND ?";
    $params[] = $_GET['desde'];
    $params[] = $_GET['hasta'];
}

$sql = "SELECT v.id, v.fecha, c.nombre AS cliente, u.nombre AS vendedor, v.total
        FROM ventas v
        JOIN clientes c ON v.cliente_id = c.id
        JOIN vendedores vd ON v.vendedor_id = vd.id
        JOIN usuarios u ON vd.usuario_id = u.id
        WHERE 1=1 $filtro ORDER BY v.fecha DESC";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$ventas = $stmt->fetchAll(PDO::FETCH_ASSOC);

// HTML PDF
$html = "<h2>Reporte de Ventas - Impreza ERP</h2>";
$html .= "<table border='1' cellpadding='4' cellspacing='0' style='width:100%'>
<tr><th># Venta</th><th>Fecha</th><th>Cliente</th><th>Vendedor</th><th>Total</th></tr>";

foreach ($ventas as $v) {
    $html .= "<tr>
        <td>{$v['id']}</td>
        <td>{$v['fecha']}</td>
        <td>{$v['cliente']}</td>
        <td>{$v['vendedor']}</td>
        <td>$" . number_format($v['total'], 0, ',', '.') . "</td>
    </tr>";
}
$html .= "</table>";

$dompdf = new Dompdf();
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'landscape');
$dompdf->render();
$dompdf->stream("reporte_ventas.pdf", ["Attachment" => false]);
exit;
?>
