<?php
session_start();
require_once '../config/db.php';
require_once '../config/auditoria.php';
if (!isset($_SESSION['usuario_id'])) {
    header('Location: ../login.php');
    exit;
}

$clientes = $pdo->query("SELECT id, nombre FROM clientes")->fetchAll(PDO::FETCH_ASSOC);
$vendedores = $pdo->query("SELECT v.id, u.nombre FROM vendedores v JOIN usuarios u ON v.usuario_id = u.id")->fetchAll(PDO::FETCH_ASSOC);
$productos = $pdo->query("SELECT id, nombre, precio, stock FROM productos")->fetchAll(PDO::FETCH_ASSOC);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $cliente_id = $_POST['cliente_id'];
    $vendedor_id = $_POST['vendedor_id'];
    $fecha = $_POST['fecha'];
    $productos_seleccionados = $_POST['producto_id'];
    $cantidades = $_POST['cantidad'];

    $pdo->beginTransaction();

    try {
        $stmt = $pdo->prepare("INSERT INTO ventas (cliente_id, vendedor_id, fecha, total) VALUES (?, ?, ?, 0)");
        $stmt->execute([$cliente_id, $vendedor_id, $fecha]);
        $venta_id = $pdo->lastInsertId();

        $total = 0;

        $detalle_stmt = $pdo->prepare("INSERT INTO detalle_ventas (venta_id, producto_id, cantidad) VALUES (?, ?, ?)");
        $update_stock = $pdo->prepare("UPDATE productos SET stock = stock - ? WHERE id = ?");

        foreach ($productos_seleccionados as $i => $producto_id) {
            $cantidad = $cantidades[$i];
            if ($cantidad > 0) {
                $detalle_stmt->execute([$venta_id, $producto_id, $cantidad]);
                $precio = $pdo->query("SELECT precio FROM productos WHERE id = $producto_id")->fetchColumn();
                $total += $precio * $cantidad;
                $update_stock->execute([$cantidad, $producto_id]);
            }
        }

        $pdo->prepare("UPDATE ventas SET total = ? WHERE id = ?")->execute([$total, $venta_id]);

        $pdo->commit();
        $mensaje = "Venta registrada exitosamente.";
    } catch (Exception $e) {
        $pdo->rollBack();
        $mensaje = "Error al registrar la venta: " . $e->getMessage();
    }
}
?>

<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <title>Registrar Venta</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>

    <meta charset="UTF-8">
    <title>Registrar Venta con Múltiples Productos</title>
</head>
<body class="bg-light"><div class="container py-5">
    <h1>Registrar Venta con Múltiples Productos</h1>
    <?php if (!empty($mensaje)) echo "<p style='color:green;'>$mensaje</p>"; ?>
    <form method="POST">
        <label>Cliente:</label>
        <select name="cliente_id" required>
            <?php foreach ($clientes as $c): ?>
                <option value="<?= $c['id'] ?>"><?= htmlspecialchars($c['nombre']) ?></option>
            <?php endforeach; ?>
        </select><br>

        <label>Vendedor:</label>
        <select name="vendedor_id" required>
            <?php foreach ($vendedores as $v): ?>
                <option value="<?= $v['id'] ?>"><?= htmlspecialchars($v['nombre']) ?></option>
            <?php endforeach; ?>
        </select><br>

        <label>Fecha:</label>
        <input type="date" name="fecha" required><br>

        <h3>Productos</h3>
        <?php foreach ($productos as $p): ?>
            <div>
                <label>
                    <input type="checkbox" name="producto_id[]" value="<?= $p['id'] ?>"> <?= htmlspecialchars($p['nombre']) ?> (Stock: <?= $p['stock'] ?>)
                </label>
                <input type="number" name="cantidad[]" placeholder="Cantidad" min="0" max="<?= $p['stock'] ?>">
            </div>
        <?php endforeach; ?>

        <br>
        <button type="submit">Registrar Venta</button>
    </form>
</div></body>
</html>
