<?php
session_start();
require_once '../config/db.php';
if (!isset($_SESSION['usuario_id'])) {
    header('Location: ../login.php');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $stmt = $pdo->prepare("INSERT INTO proveedores (nombre, contacto, telefono, email) VALUES (?, ?, ?, ?)");
    $stmt->execute([$_POST['nombre'], $_POST['contacto'], $_POST['telefono'], $_POST['email']]);
    header("Location: proveedores.php");
    exit;
}

$proveedores = $pdo->query("SELECT * FROM proveedores")->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Proveedores - Impreza ERP</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-5">
    <h1 class="mb-4">Proveedores</h1>

    <form method="POST" class="mb-4">
        <input class="form-control mb-2" name="nombre" placeholder="Nombre" required>
        <input class="form-control mb-2" name="contacto" placeholder="Contacto">
        <input class="form-control mb-2" name="telefono" placeholder="Teléfono">
        <input class="form-control mb-2" name="email" placeholder="Email">
        <button class="btn btn-primary">Agregar Proveedor</button>
    </form>

    <table class="table table-bordered">
        <thead class="table-dark">
            <tr><th>ID</th><th>Nombre</th><th>Contacto</th><th>Teléfono</th><th>Email</th></tr>
        </thead>
        <tbody>
            <?php foreach ($proveedores as $p): ?>
                <tr>
                    <td><?= $p['id'] ?></td>
                    <td><?= htmlspecialchars($p['nombre']) ?></td>
                    <td><?= htmlspecialchars($p['contacto']) ?></td>
                    <td><?= htmlspecialchars($p['telefono']) ?></td>
                    <td><?= htmlspecialchars($p['email']) ?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>
</body>
</html>
