<?php
session_start();
require_once '../config/db.php';
if (!isset($_SESSION['usuario_id'])) {
    header('Location: ../login.php');
    exit;
}

// Cargar clientes y vendedores
$clientes = $pdo->query("SELECT id, nombre FROM clientes")->fetchAll(PDO::FETCH_ASSOC);
$vendedores = $pdo->query("SELECT vd.id, u.nombre FROM vendedores vd JOIN usuarios u ON vd.usuario_id = u.id")->fetchAll(PDO::FETCH_ASSOC);

// Cargar productos vendidos (dummy data por ahora)
$condiciones = [];
$params = [];

if (!empty($_GET['cliente_id'])) {
    $condiciones[] = "v.cliente_id = ?";
    $params[] = $_GET['cliente_id'];
}
if (!empty($_GET['vendedor_id'])) {
    $condiciones[] = "v.vendedor_id = ?";
    $params[] = $_GET['vendedor_id'];
}

$query = "
    SELECT c.nombre AS cliente, u.nombre AS vendedor, p.nombre AS producto, SUM(dv.cantidad) AS total_vendido
    FROM detalle_ventas dv
    JOIN ventas v ON dv.venta_id = v.id
    JOIN productos p ON dv.producto_id = p.id
    JOIN clientes c ON v.cliente_id = c.id
    JOIN vendedores vd ON v.vendedor_id = vd.id
    JOIN usuarios u ON vd.usuario_id = u.id
";

if ($condiciones) {
    $query .= " WHERE " . implode(" AND ", $condiciones);
}
$query .= " GROUP BY cliente, vendedor, producto ORDER BY cliente, vendedor";

$stmt = $pdo->prepare($query);
$stmt->execute($params);
$resultados = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Productos Vendidos - Impreza ERP</title>
</head>
<body>
    <h1>Productos Vendidos por Cliente y Vendedor</h1>
    <form method="GET">
        <label for="cliente_id">Cliente:</label>
        <select name="cliente_id">
            <option value="">Todos</option>
            <?php foreach ($clientes as $c): ?>
                <option value="<?= $c['id'] ?>" <?= ($_GET['cliente_id'] ?? '') == $c['id'] ? 'selected' : '' ?>>
                    <?= htmlspecialchars($c['nombre']) ?>
                </option>
            <?php endforeach; ?>
        </select>

        <label for="vendedor_id">Vendedor:</label>
        <select name="vendedor_id">
            <option value="">Todos</option>
            <?php foreach ($vendedores as $v): ?>
                <option value="<?= $v['id'] ?>" <?= ($_GET['vendedor_id'] ?? '') == $v['id'] ? 'selected' : '' ?>>
                    <?= htmlspecialchars($v['nombre']) ?>
                </option>
            <?php endforeach; ?>
        </select>

        <button type="submit">Filtrar</button>
    </form>

    <table border="1">
        <tr><th>Cliente</th><th>Vendedor</th><th>Producto</th><th>Total Vendido</th></tr>
        <?php foreach ($resultados as $r): ?>
            <tr>
                <td><?= htmlspecialchars($r['cliente']) ?></td>
                <td><?= htmlspecialchars($r['vendedor']) ?></td>
                <td><?= htmlspecialchars($r['producto']) ?></td>
                <td><?= $r['total_vendido'] ?></td>
            </tr>
        <?php endforeach; ?>
    </table>
</body>
</html>
