<?php
session_start();
require_once '../config/db.php';
require_once '../config/auditoria.php';
if (!isset($_SESSION['usuario_id'])) {
    header('Location: ../login.php');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $stmt = $pdo->prepare("INSERT INTO productos (nombre, precio, stock, stock_minimo) VALUES (?, ?, ?, ?)");
    $stmt->execute([$_POST['nombre'], $_POST['precio'], $_POST['stock'], $_POST['stock_minimo']]);
    registrarAuditoria($pdo, $_SESSION['usuario_id'], 'Nuevo producto: ' . $_POST['nombre'], 'Productos');
    header("Location: productos.php");
    exit;
}

$productos = $pdo->query("SELECT * FROM productos")->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Productos - Impreza ERP</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
    <div class="container py-5">
        <h1 class="mb-4">Gestión de Productos</h1>

        <form method="POST" class="mb-4">
            <input type="text" name="nombre" class="form-control mb-2" placeholder="Nombre del producto" required>
            <input type="number" step="0.01" name="precio" class="form-control mb-2" placeholder="Precio" required>
            <input type="number" name="stock" class="form-control mb-2" placeholder="Stock inicial" required>
            <input type="number" name="stock_minimo" class="form-control mb-2" placeholder="Stock mínimo" required>
            <button class="btn btn-success">Agregar producto</button>
        </form>

        <h2>Listado de productos</h2>
        <table class="table table-bordered">
            <thead class="table-dark">
                <tr><th>ID</th><th>Nombre</th><th>Precio</th><th>Stock</th><th>Stock Mínimo</th></tr>
            </thead>
            <tbody>
                <?php foreach ($productos as $p): ?>
                    <tr class="<?= ($p['stock'] < $p['stock_minimo']) ? 'table-danger' : '' ?>">
                        <td><?= $p['id'] ?></td>
                        <td><?= htmlspecialchars($p['nombre']) ?></td>
                        <td>$<?= $p['precio'] ?></td>
                        <td><?= $p['stock'] ?></td>
                        <td><?= $p['stock_minimo'] ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</body>
</html>
