<?php
require_once '../config/db.php';
session_start();

if (!isset($_GET['email'])) {
    echo "Falta correo. Usa ?email=cliente@dominio.com";
    exit;
}

$email = $_GET['email'];
$cliente = $pdo->prepare("SELECT id, nombre FROM clientes WHERE email = ?");
$cliente->execute([$email]);
$c = $cliente->fetch(PDO::FETCH_ASSOC);

if (!$c) {
    echo "Cliente no encontrado.";
    exit;
}

$ventas = $pdo->prepare("SELECT id, fecha, total FROM ventas WHERE cliente_id = ? ORDER BY fecha DESC");
$ventas->execute([$c['id']]);
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Portal Cliente - <?= htmlspecialchars($c['nombre']) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-5">
    <h3 class="mb-4">Bienvenido, <?= htmlspecialchars($c['nombre']) ?></h3>
    <h5>Historial de Compras</h5>
    <table class="table table-bordered">
        <thead class="table-dark">
            <tr><th>ID Venta</th><th>Fecha</th><th>Total</th><th>Factura</th></tr>
        </thead>
        <tbody>
            <?php foreach ($ventas as $v): ?>
                <tr>
                    <td><?= $v['id'] ?></td>
                    <td><?= $v['fecha'] ?></td>
                    <td>$<?= number_format($v['total'], 0, ',', '.') ?></td>
                    <td><a href="../modules/factura.php?id=<?= $v['id'] ?>" target="_blank" class="btn btn-sm btn-primary">Ver PDF</a></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>
</body>
</html>
