<?php
session_start();
require_once '../config/db.php';
require_once '../config/auditoria.php';
if (!isset($_SESSION['usuario_id'])) {
    header('Location: ../login.php');
    exit;
}

// Obtener ventas con saldo pendiente
$ventas = $pdo->query("
    SELECT v.id, c.nombre AS cliente, v.total,
    IFNULL((SELECT SUM(monto) FROM pagos WHERE venta_id = v.id), 0) AS abonado
    FROM ventas v
    JOIN clientes c ON v.cliente_id = c.id
    WHERE v.estado != 'anulada'
")->fetchAll(PDO::FETCH_ASSOC);

// Procesar pago
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $stmt = $pdo->prepare("INSERT INTO pagos (venta_id, monto, fecha) VALUES (?, ?, ?)");
    $stmt->execute([$_POST['venta_id'], $_POST['monto'], $_POST['fecha']]);
    registrarAuditoria($pdo, $_SESSION['usuario_id'], 'Pago parcial venta ID: ' . $_POST['venta_id'], 'Pagos');
    header("Location: pagos.php");
    exit;
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Pagos Parciales - Impreza ERP</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-5">
    <h1 class="mb-4">Pagos Parciales y Deudas</h1>

    <form method="POST" class="mb-4">
        <select name="venta_id" class="form-select mb-2" required>
            <option value="">Seleccione Venta</option>
            <?php foreach ($ventas as $v): ?>
                <?php $pendiente = $v['total'] - $v['abonado']; ?>
                <?php if ($pendiente > 0): ?>
                    <option value="<?= $v['id'] ?>">
                        #<?= $v['id'] ?> - <?= htmlspecialchars($v['cliente']) ?> (Pendiente: $<?= number_format($pendiente, 0, ',', '.') ?>)
                    </option>
                <?php endif; ?>
            <?php endforeach; ?>
        </select>

        <input type="number" step="0.01" name="monto" class="form-control mb-2" placeholder="Monto a abonar" required>
        <input type="date" name="fecha" class="form-control mb-2" required>
        <button class="btn btn-success">Registrar Pago</button>
    </form>

    <h4>Estado de Cuenta</h4>
    <table class="table table-bordered">
        <thead class="table-dark"><tr><th>ID Venta</th><th>Cliente</th><th>Total</th><th>Abonado</th><th>Pendiente</th></tr></thead>
        <tbody>
            <?php foreach ($ventas as $v): ?>
                <tr class="<?= ($v['total'] - $v['abonado']) > 0 ? 'table-warning' : 'table-success' ?>">
                    <td><?= $v['id'] ?></td>
                    <td><?= htmlspecialchars($v['cliente']) ?></td>
                    <td>$<?= number_format($v['total'], 0, ',', '.') ?></td>
                    <td>$<?= number_format($v['abonado'], 0, ',', '.') ?></td>
                    <td>$<?= number_format($v['total'] - $v['abonado'], 0, ',', '.') ?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>
</body>
</html>
