<?php
session_start();
require_once '../config/db.php';
if (!isset($_SESSION['usuario_id'])) {
    header('Location: ../login.php');
    exit;
}

// Top productos
$productos = $pdo->query("
    SELECT p.nombre, SUM(dv.cantidad) AS total_vendido
    FROM detalle_ventas dv
    JOIN productos p ON dv.producto_id = p.id
    GROUP BY p.nombre
    ORDER BY total_vendido DESC
    LIMIT 10
")->fetchAll(PDO::FETCH_ASSOC);

// Top vendedores
$vendedores = $pdo->query("
    SELECT u.nombre, COUNT(v.id) AS total_ventas
    FROM ventas v
    JOIN vendedores vd ON v.vendedor_id = vd.id
    JOIN usuarios u ON vd.usuario_id = u.id
    GROUP BY u.nombre
    ORDER BY total_ventas DESC
")->fetchAll(PDO::FETCH_ASSOC);

$labels_productos = array_column($productos, 'nombre');
$data_productos = array_column($productos, 'total_vendido');

$labels_vendedores = array_column($vendedores, 'nombre');
$data_vendedores = array_column($vendedores, 'total_ventas');
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Gráficos por Producto y Vendedor - Impreza ERP</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body class="bg-light">
    <div class="container py-5">
        <h1 class="mb-4">Gráficos por Producto y Vendedor</h1>

        <div class="mb-5">
            <h3>Top 10 Productos Vendidos</h3>
            <canvas id="productosChart"></canvas>
        </div>

        <div>
            <h3>Ventas por Vendedor</h3>
            <canvas id="vendedoresChart"></canvas>
        </div>
    </div>

    <script>
        new Chart(document.getElementById('productosChart').getContext('2d'), {
            type: 'bar',
            data: {
                labels: <?= json_encode($labels_productos) ?>,
                datasets: [{
                    label: 'Unidades vendidas',
                    data: <?= json_encode($data_productos) ?>,
                    borderWidth: 1
                }]
            },
            options: { responsive: true, scales: { y: { beginAtZero: true } } }
        });

        new Chart(document.getElementById('vendedoresChart').getContext('2d'), {
            type: 'pie',
            data: {
                labels: <?= json_encode($labels_vendedores) ?>,
                datasets: [{
                    label: 'Ventas realizadas',
                    data: <?= json_encode($data_vendedores) ?>,
                    borderWidth: 1
                }]
            },
            options: { responsive: true }
        });
    </script>
</body>
</html>
