<?php
require '../vendor/autoload.php';
require_once '../config/db.php';

use Dompdf\Dompdf;

if (!isset($_GET['id'])) die("Falta ID");

$id = $_GET['id'];

$venta = $pdo->prepare("
    SELECT v.id, v.fecha, c.nombre AS cliente, c.email
    FROM ventas v
    JOIN clientes c ON v.cliente_id = c.id
    WHERE v.id = ?
");
$venta->execute([$id]);
$v = $venta->fetch(PDO::FETCH_ASSOC);

$items = $pdo->prepare("
    SELECT p.nombre, pv.precio, pv.cantidad
    FROM productos_vendidos pv
    JOIN productos p ON pv.producto_id = p.id
    WHERE pv.venta_id = ?
");
$items->execute([$id]);
$productos = $items->fetchAll(PDO::FETCH_ASSOC);

$total = 0;
$html = "<h2>Factura N° {$v['id']} - Impreza ERP</h2>";
$html .= "<p><strong>Cliente:</strong> {$v['cliente']}<br><strong>Correo:</strong> {$v['email']}<br><strong>Fecha:</strong> {$v['fecha']}</p>";
$html .= "<table border='1' cellpadding='4' cellspacing='0' style='width:100%'><tr><th>Producto</th><th>Precio</th><th>Cantidad</th><th>Total</th></tr>";

foreach ($productos as $p) {
    $subtotal = $p['precio'] * $p['cantidad'];
    $html .= "<tr>
        <td>{$p['nombre']}</td>
        <td>$" . number_format($p['precio'], 0, ',', '.') . "</td>
        <td>{$p['cantidad']}</td>
        <td>$" . number_format($subtotal, 0, ',', '.') . "</td>
    </tr>";
    $total += $subtotal;
}

$html .= "<tr><td colspan='3' align='right'><strong>Total</strong></td><td><strong>$" . number_format($total, 0, ',', '.') . "</strong></td></tr></table>";

$dompdf = new Dompdf();
$dompdf->loadHtml($html);
$dompdf->setPaper('A4');
$dompdf->render();
$dompdf->stream("factura_{$id}.pdf", ["Attachment" => false]);
exit;
?>
