<?php
require_once '../vendor/autoload.php';
require_once '../config/db.php';

use Dompdf\Dompdf;

$ventas = $pdo->query("
    SELECT v.id, c.nombre AS cliente, u.nombre AS vendedor, v.fecha, v.total, v.estado
    FROM ventas v
    JOIN clientes c ON v.cliente_id = c.id
    JOIN vendedores vd ON v.vendedor_id = vd.id
    JOIN usuarios u ON vd.usuario_id = u.id
    ORDER BY v.fecha DESC
")->fetchAll(PDO::FETCH_ASSOC);

$html = '<h1>Reporte de Ventas</h1><table border="1" width="100%" cellspacing="0" cellpadding="5">
<tr><th>ID</th><th>Cliente</th><th>Vendedor</th><th>Fecha</th><th>Total</th><th>Estado</th></tr>';
foreach ($ventas as $v) {
    $html .= '<tr>
        <td>' . $v['id'] . '</td>
        <td>' . htmlspecialchars($v['cliente']) . '</td>
        <td>' . htmlspecialchars($v['vendedor']) . '</td>
        <td>' . $v['fecha'] . '</td>
        <td>$' . number_format($v['total'], 0, ',', '.') . '</td>
        <td>' . $v['estado'] . '</td>
    </tr>';
}
$html .= '</table>';

$dompdf = new Dompdf();
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'landscape');
$dompdf->render();
$dompdf->stream("reporte_ventas.pdf");
exit;
?>
