<?php
require_once '../config/db.php';

header('Content-Type: text/csv; charset=utf-8');
header('Content-Disposition: attachment; filename=ventas.csv');
$output = fopen('php://output', 'w');
fputcsv($output, ['ID', 'Cliente', 'Vendedor', 'Fecha', 'Total', 'Estado']);

$ventas = $pdo->query("
    SELECT v.id, c.nombre AS cliente, u.nombre AS vendedor, v.fecha, v.total, v.estado
    FROM ventas v
    JOIN clientes c ON v.cliente_id = c.id
    JOIN vendedores vd ON v.vendedor_id = vd.id
    JOIN usuarios u ON vd.usuario_id = u.id
    ORDER BY v.fecha DESC
")->fetchAll(PDO::FETCH_ASSOC);

foreach ($ventas as $v) {
    fputcsv($output, [$v['id'], $v['cliente'], $v['vendedor'], $v['fecha'], $v['total'], $v['estado']]);
}
fclose($output);
exit;
?>
