<?php
session_start();
require_once '../config/db.php';
if (!isset($_SESSION['usuario_id'])) {
    header('Location: ../login.php');
    exit;
}

$id = $_GET['id'] ?? null;
if (!$id) {
    echo "ID no válido.";
    exit;
}

$venta = $pdo->prepare("SELECT * FROM ventas WHERE id = ?");
$venta->execute([$id]);
$data = $venta->fetch(PDO::FETCH_ASSOC);
if (!$data) {
    echo "Venta no encontrada.";
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $fecha = $_POST['fecha'];
    $total = $_POST['total'];
    $estado = $_POST['estado'];
    $pdo->prepare("UPDATE ventas SET fecha = ?, total = ?, estado = ? WHERE id = ?")->execute([$fecha, $total, $estado, $id]);
    header("Location: ver_ventas.php");
    exit;
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Editar Venta</title>
</head>
<body>
    <h1>Editar Venta #<?= $id ?></h1>
    <form method="POST">
        <label for="fecha">Fecha:</label>
        <input type="date" name="fecha" value="<?= $data['fecha'] ?>" required><br>

        <label for="total">Total:</label>
        <input type="number" step="0.01" name="total" value="<?= $data['total'] ?>" required><br>

        <label for="estado">Estado:</label>
        <select name="estado" required>
            <option value="pendiente" <?= $data['estado'] == 'pendiente' ? 'selected' : '' ?>>Pendiente</option>
            <option value="pagada" <?= $data['estado'] == 'pagada' ? 'selected' : '' ?>>Pagada</option>
            <option value="anulada" <?= $data['estado'] == 'anulada' ? 'selected' : '' ?>>Anulada</option>
        </select><br>

        <button type="submit">Guardar Cambios</button>
    </form>
</body>
</html>
