<?php
session_start();
require_once '../config/db.php';

$ventas_dia = $pdo->query("SELECT SUM(total) AS total FROM ventas WHERE DATE(fecha) = CURDATE()")->fetch(PDO::FETCH_ASSOC)['total'] ?? 0;
$clientes = $pdo->query("SELECT COUNT(*) AS total FROM clientes")->fetch(PDO::FETCH_ASSOC)['total'];
$productos_criticos = $pdo->query("SELECT COUNT(*) AS total FROM productos WHERE stock < stock_minimo")->fetch(PDO::FETCH_ASSOC)['total'];

$ventas_mes = $pdo->query("SELECT DATE(fecha) as fecha, SUM(total) as total FROM ventas WHERE MONTH(fecha) = MONTH(CURDATE()) GROUP BY fecha ORDER BY fecha")->fetchAll(PDO::FETCH_ASSOC);
$labels = array_column($ventas_mes, 'fecha');
$datos = array_column($ventas_mes, 'total');
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Dashboard - Impreza ERP</title>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-4">
    <h2 class="mb-4">Dashboard General</h2>

    <div class="row text-center mb-4">
        <div class="col-md-4">
            <div class="card shadow-sm p-3 bg-white">
                <h4>Ventas Hoy</h4>
                <p class="fs-3 text-success">$<?= number_format($ventas_dia, 0, ',', '.') ?></p>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card shadow-sm p-3 bg-white">
                <h4>Clientes Registrados</h4>
                <p class="fs-3"><?= $clientes ?></p>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card shadow-sm p-3 bg-white">
                <h4>Productos Críticos</h4>
                <p class="fs-3 text-danger"><?= $productos_criticos ?></p>
            </div>
        </div>
    </div>

    <div class="card p-4">
        <h5>Ventas por día (mes actual)</h5>
        <canvas id="graficoVentas"></canvas>
    </div>
</div>

<script>
const ctx = document.getElementById('graficoVentas');
const grafico = new Chart(ctx, {
    type: 'line',
    data: {
        labels: <?= json_encode($labels) ?>,
        datasets: [{
            label: 'Ventas por día',
            data: <?= json_encode($datos) ?>,
            borderWidth: 2,
            fill: false,
            tension: 0.2
        }]
    },
    options: {
        responsive: true,
        scales: {
            y: {
                beginAtZero: true
            }
        }
    }
});
</script>
</body>
</html>
