<?php
session_start();
require_once '../config/db.php';
require_once '../config/auditoria.php';
if (!isset($_SESSION['usuario_id'])) {
    header('Location: ../login.php');
    exit;
}

$proveedores = $pdo->query("SELECT * FROM proveedores")->fetchAll(PDO::FETCH_ASSOC);
$productos = $pdo->query("SELECT * FROM productos")->fetchAll(PDO::FETCH_ASSOC);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $stmt = $pdo->prepare("INSERT INTO compras (proveedor_id, producto_id, cantidad, precio_unitario, fecha) VALUES (?, ?, ?, ?, ?)");
    $stmt->execute([$_POST['proveedor_id'], $_POST['producto_id'], $_POST['cantidad'], $_POST['precio_unitario'], $_POST['fecha']]);

    $pdo->prepare("UPDATE productos SET stock = stock + ? WHERE id = ?")
        ->execute([$_POST['cantidad'], $_POST['producto_id']]);

    registrarAuditoria($pdo, $_SESSION['usuario_id'], 'Compra de producto ID: ' . $_POST['producto_id'], 'Compras');
    header("Location: compras.php");
    exit;
}

$compras = $pdo->query("
    SELECT c.id, pr.nombre AS proveedor, p.nombre AS producto, c.cantidad, c.precio_unitario, c.fecha
    FROM compras c
    JOIN proveedores pr ON c.proveedor_id = pr.id
    JOIN productos p ON c.producto_id = p.id
    ORDER BY c.fecha DESC
")->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Compras - Impreza ERP</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-5">
    <h1 class="mb-4">Registro de Compras</h1>

    <form method="POST" class="mb-4">
        <select class="form-select mb-2" name="proveedor_id" required>
            <option value="">Seleccione Proveedor</option>
            <?php foreach ($proveedores as $p): ?>
                <option value="<?= $p['id'] ?>"><?= htmlspecialchars($p['nombre']) ?></option>
            <?php endforeach; ?>
        </select>

        <select class="form-select mb-2" name="producto_id" required>
            <option value="">Seleccione Producto</option>
            <?php foreach ($productos as $p): ?>
                <option value="<?= $p['id'] ?>"><?= htmlspecialchars($p['nombre']) ?></option>
            <?php endforeach; ?>
        </select>

        <input type="number" name="cantidad" class="form-control mb-2" placeholder="Cantidad" required>
        <input type="number" step="0.01" name="precio_unitario" class="form-control mb-2" placeholder="Precio unitario" required>
        <input type="date" name="fecha" class="form-control mb-2" required>

        <button class="btn btn-success">Registrar Compra</button>
    </form>

    <table class="table table-bordered">
        <thead class="table-dark"><tr><th>ID</th><th>Proveedor</th><th>Producto</th><th>Cantidad</th><th>Precio Unitario</th><th>Fecha</th></tr></thead>
        <tbody>
            <?php foreach ($compras as $c): ?>
                <tr>
                    <td><?= $c['id'] ?></td>
                    <td><?= htmlspecialchars($c['proveedor']) ?></td>
                    <td><?= htmlspecialchars($c['producto']) ?></td>
                    <td><?= $c['cantidad'] ?></td>
                    <td>$<?= $c['precio_unitario'] ?></td>
                    <td><?= $c['fecha'] ?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>
</body>
</html>
