<?php
session_start();
require_once '../config/db.php';
if (!isset($_SESSION['usuario_id']) || $_SESSION['rol'] !== 'admin') {
    header('Location: ../login.php');
    exit;
}

$audit = $pdo->query("
    SELECT a.id, u.nombre, a.modulo, a.accion, a.fecha
    FROM auditoria a
    JOIN usuarios u ON a.usuario_id = u.id
    ORDER BY a.fecha DESC
")->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Auditoría - Impreza ERP</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-5">
    <h1 class="mb-4">Historial de Movimientos</h1>

    <table class="table table-bordered">
        <thead class="table-dark">
            <tr><th>ID</th><th>Usuario</th><th>Módulo</th><th>Acción</th><th>Fecha</th></tr>
        </thead>
        <tbody>
            <?php foreach ($audit as $a): ?>
                <tr>
                    <td><?= $a['id'] ?></td>
                    <td><?= htmlspecialchars($a['nombre']) ?></td>
                    <td><?= htmlspecialchars($a['modulo']) ?></td>
                    <td><?= htmlspecialchars($a['accion']) ?></td>
                    <td><?= $a['fecha'] ?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>
</body>
</html>
