<?php
session_start();
if (!isset($_SESSION['usuario_id'])) {
    header('Location: login.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <title>Dashboard - Impreza ERP</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>

<body class="bg-light">
    <div class="container py-5">
        <h1 class="mb-4">Bienvenido, <?= htmlspecialchars($_SESSION['nombre']) ?> (<?= $_SESSION['rol'] ?>)</h1>
        <div class="list-group">
            <a href="modules/clientes.php" class="list-group-item list-group-item-action">Clientes</a>
            <a href="modules/productos.php" class="list-group-item list-group-item-action">Productos</a>
            <a href="modules/registrar_venta.php" class="list-group-item list-group-item-action">Registrar Venta</a>
            <a href="modules/ver_ventas.php" class="list-group-item list-group-item-action">Ver Ventas</a>
            <a href="modules/productos_vendidos.php" class="list-group-item list-group-item-action">Productos Vendidos</a>
            <a href="modules/estadisticas.php" class="list-group-item list-group-item-success">Estadísticas de Ventas</a>
            <?php if ($_SESSION['rol'] === 'admin'): ?>
                <a href="modules/usuarios.php" class="list-group-item list-group-item-primary">Gestión de Usuarios</a>
            <?php endif; ?>
            <a href="logout.php" class="list-group-item list-group-item-danger">Cerrar sesión</a>
        </div>
    </div>
</body>
</html>
